function h_fig = plot_timeseries(id_fig,show_PMU,show_RTU,idx_PMU,idx_RTU,V_LF,V_PMU,V_RTU,V_LWLS,V_NWLS)

show_SE = idx_PMU(show_PMU);

h_fig = figure(id_fig);
clf;

subplot(2,2,1);

hold on;
plot(real(V_PMU(show_PMU,:)),'-r');
plot(real(V_LWLS(show_SE,:)),'-b');
plot(real(V_LF(show_SE,:)),'-m');
hold off,

grid on;

title(['Bus ' int2str(idx_PMU(show_PMU)) ': Voltage Phasor']);
xlabel('Timestep');
ylabel('Real Part (pu)');
legend({'PMU','LWLS','LF'},'Location','SouthEast');

subplot(2,2,3);

hold on;
plot(imag(V_PMU(show_PMU,:)),'-r');
plot(imag(V_LWLS(show_SE,:)),'-b');
plot(imag(V_LF(show_SE,:)),'-m');
hold off;

grid on;

xlabel('Timestep');
ylabel('Imaginary Part (pu)');
legend({'PMU','LWLS','LF'},'Location','SouthEast');

show_SE = idx_RTU(show_RTU);

subplot(2,2,2);

hold on;
plot(abs(V_RTU(show_RTU,:)),'-r');
plot(abs(V_NWLS(show_SE,:)),'-b');
plot(abs(V_LF(show_SE,:)),'-m');
hold off;

grid on;

title(['Bus ' int2str(idx_RTU(show_RTU)) ': Voltage Phasor']);
xlabel('Timestep');
ylabel('Magnitude (pu)');
legend({'PMU/RTU','NWLS','LF'},'Location','SouthEast');

subplot(2,2,4);

hold on;
plot(angle(V_RTU(show_RTU,:)),'-r');
plot(angle(V_NWLS(show_SE,:)),'-b');
plot(angle(V_LF(show_SE,:)),'-m');
hold off;

xlabel('Timestep');
ylabel('Angle (rad)');
legend({'PMU/RTU','NWLS','LF'},'Location','SouthEast');

grid on;

set(gca,'LooseInset',get(gca,'TightInset'));

end